import groovy.json.JsonSlurper
import org.serviio.library.metadata.*
import org.serviio.library.online.*
import org.serviio.util.*

/********************************************************************
 * veetle.com plugin for Serviio
 * 
 * @author X S Inattar
 *
 * URLs to use as video webresource: 
 *  - http://veetle.com/index.php/listing/index/animation/-1
 *  - http://veetle.com/index.php/listing/index/entertainment/20
 *  - http://veetle.com/index.php/listing/index/shows/10
 * 
 * Version:
 *    V1: August 12, 2012 - Initial Release
 * 
 ********************************************************************/

class Veetle extends WebResourceUrlExtractor {

    
    final VALID_FEED_URL = 'http*://.*?veetle\\.com/index\\.php/listing/index/(.*?)/(.*?)$'
    
    String getExtractorName() {
        return 'veetle.com'
    }
    
    boolean extractorMatches(URL feedUrl) {
        return feedUrl ==~ VALID_FEED_URL
    }


    WebResourceContainer extractItems(URL resourceUrl, int maxItemsToRetrieve)
    {
        def feed_matcher = resourceUrl =~  VALID_FEED_URL
        def category = feed_matcher[0][1]    
        def items_to_fetch = feed_matcher[0][2]
        print category
        print items_to_fetch
        
        def category_id = 0
        
        switch ( category.toUpperCase() )
        {
            case "ALL":
                category_id = 0
                break
            case "ENTERTAINMENT":
                category_id = 10
                break        
            case "SHOWS":
                category_id = 20
                break        
            case "NEWS":
                category_id = 30
                break        
            case "GAMING":
                category_id = 40
                break        
            case "COMEDY":
                category_id = 50
                break        
            case "ANIMATION":
                category_id = 60
                break        
            case "MUSIC":
                category_id = 70
                break        
            case "SPORTS":
                category_id = 80
                break        
            case "EDUCATION":
                category_id = 90
                break        
            case "RELIGION":
                category_id = 100
                break        
            case "MOBILE":
                category_id = 110
                break        
        }
    
        // Example Response Data
        def rest_response = new URL("http://veetle.com/index.php/listing/ajaxStreamByCategory/" + category_id + "/0/" + items_to_fetch +"/0").text 
        
        // Parse the response
        def list = new JsonSlurper().parseText( rest_response )
        
        def items_count = list.totalCount as int
        def items_to_fetch_count = items_to_fetch as int
        
        if (items_to_fetch_count == -1) {
            items_to_fetch_count = items_count
        }
        
        if ( items_count > items_to_fetch_count ) {
            items_count = items_to_fetch_count
        }

        List<WebResourceItem> items = []
        
        def itemsAdded = 0;
        for( int i = 0; i < items_count ; i++) {
            String programName = list.payload.title [i]
            String programID = list.payload.channelId [i]
            String thumbnail = list.payload.thumbnailUrl [i]
                        
            WebResourceItem item = new WebResourceItem( title: programName, additionalInfo : ['thumbID': thumbnail , 'programID': programID])
            println "item = $item"
            items << item
            itemsAdded++            
        }
            
        return new WebResourceContainer(title: 'Veetle - ' + category.capitalize(), items: items)
    }
    ContentURLContainer extractUrl(WebResourceItem mediaitem, PreferredQuality requestedQuality) {        
                
        String programID = mediaitem.getAdditionalInfo()['programID'] 
        
        def program_rest_response = new URL ("http://veetle.com/index.php/stream/ajaxStreamLocation/" + programID + "/flash").text
        def program_details = new JsonSlurper().parseText( program_rest_response )
        String contentURL = program_details.payload
                
        String thumbnailURL = mediaitem.getAdditionalInfo()['thumbID']
        
        return new ContentURLContainer(fileType: MediaFileType.VIDEO, contentUrl: contentURL, thumbnailUrl: thumbnailURL,  live: true)
    }
    
    static void main(args) {
    
        Veetle extractor = new  Veetle()
        
        WebResourceContainer container = extractor.extractItems( new URL("http://veetle.com/index.php/listing/index/animation/-1"), 20)
        container.getItems().each {
            println it
            ContentURLContainer result = extractor.extractUrl(it, PreferredQuality.MEDIUM)
            println result 
        }           
    }

}